// normally the model is passed to the view instead of the view creating the model
define([
    'backbone',
    'marionette',
    'modules/form/section-view',
    'text!modules/form/section-with-heading.html',

    'json!modules/appointments/booked/appointment-cancel-reason-form.json',
], function(
    Backbone,
    Marionette,
    SectionView,
    template,
    metadata
) {
    'use strict';

    return SectionView.extend({
        template: template,
        modelEvents: {'change:cancelAppointment': 'showHideChildrenQuestionsAndValidation'},
        initialize: function(options) {
            var sectionName = 'cancel-reason-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);
            this.collection.get('cancelReason').set('values', this.convertCancelReasons(options.cancelReasonList));
            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
            this.validator = options.validator;
        },
        onRender: function() {
            this.initChildren();
        },
        showHideChildrenQuestionsAndValidation: function() {
            var children;
            var isHidingQuestion;

            if (!this.isDestroyed()) {
                children = this.$el.find('.selectmenu-question');
                isHidingQuestion = !(this.model.get('cancelAppointment'));
                children.toggleClass('hidden',
                    isHidingQuestion);

                if (isHidingQuestion) {
                    this.hideValidationErrorsFor(children);
                }
            }
        },
        convertCancelReasons: function(reasons) {
            return reasons.toJSON();
        },
    });
});
